<?php 
/**
 * Plugin Name:       WooCommerce Sync for QuickBooks Online - Custom Field Mapping
 * Plugin URI:        http://myworks.design/software/woocommerce-quickbooks-online-automatic-sync/
 * Description:       Custom field mapping functionality for WooCommerce Sync for QuickBooks Online
 * Version:           1.3.0
 * Author:            MyWorks Software
 * Author URI:        http://myworks.software
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       mw_wc_qbo_sync_cfm
 * Domain Path:       /languages
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function mwqbosync_cfm_plugin_avtivation(){

  $active_plugins = get_option('active_plugins');
  if(in_array('myworks-woo-sync-for-quickbooks-online/myworks-woo-sync-for-quickbooks-online.php',$active_plugins)){
	update_option('mw_wc_qbo_sync_sh_cfm_hash','1c8fb916d15a39efd2ccac47ec6b3051bd494b94');
  	return true;
  }else{
  	$error_message = __('This plugin requires <a target="_blank" href="http://myworks.design/software/woocommerce-quickbooks-online-automatic-sync/">MyWorks Woo Sync for QuickBooks Online</a> plugin to be active!', 'mw_wc_qbo_sync');
	die($error_message);
  }  
}
 
register_activation_hook(__FILE__, 'mwqbosync_cfm_plugin_avtivation');

function mwqbosync_cfm_plugin_deactivation(){
	delete_option('mw_wc_qbo_sync_sh_cfm_hash');
	return true;
}

register_deactivation_hook( __FILE__, 'mwqbosync_cfm_plugin_deactivation' );