<?php

/**
 * Schema object for: PurchaseOrderAddRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_PurchaseOrderAddRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = 'PurchaseOrderAdd';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'VendorRef ListID' => 'IDTYPE',
  'VendorRef FullName' => 'STRTYPE',
  'ClassRef ListID' => 'IDTYPE',
  'ClassRef FullName' => 'STRTYPE',
  'ShipToEntityRef ListID' => 'IDTYPE',
  'ShipToEntityRef FullName' => 'STRTYPE',
  'TemplateRef ListID' => 'IDTYPE',
  'TemplateRef FullName' => 'STRTYPE',
  'TxnDate' => 'DATETYPE',
  'RefNumber' => 'STRTYPE',
  'VendorAddress Addr1' => 'STRTYPE',
  'VendorAddress Addr2' => 'STRTYPE',
  'VendorAddress Addr3' => 'STRTYPE',
  'VendorAddress Addr4' => 'STRTYPE',
  'VendorAddress Addr5' => 'STRTYPE',
  'VendorAddress City' => 'STRTYPE',
  'VendorAddress State' => 'STRTYPE',
  'VendorAddress PostalCode' => 'STRTYPE',
  'VendorAddress Country' => 'STRTYPE',
  'VendorAddress Note' => 'STRTYPE',
  'ShipAddress Addr1' => 'STRTYPE',
  'ShipAddress Addr2' => 'STRTYPE',
  'ShipAddress Addr3' => 'STRTYPE',
  'ShipAddress Addr4' => 'STRTYPE',
  'ShipAddress Addr5' => 'STRTYPE',
  'ShipAddress City' => 'STRTYPE',
  'ShipAddress State' => 'STRTYPE',
  'ShipAddress PostalCode' => 'STRTYPE',
  'ShipAddress Country' => 'STRTYPE',
  'ShipAddress Note' => 'STRTYPE',
  'TermsRef ListID' => 'IDTYPE',
  'TermsRef FullName' => 'STRTYPE',
  'DueDate' => 'DATETYPE',
  'ExpectedDate' => 'DATETYPE',
  'ShipMethodRef ListID' => 'IDTYPE',
  'ShipMethodRef FullName' => 'STRTYPE',
  'FOB' => 'STRTYPE',
  'Memo' => 'STRTYPE',
  'VendorMsg' => 'STRTYPE',
  'IsToBePrinted' => 'BOOLTYPE',
  'IsToBeEmailed' => 'BOOLTYPE',
  'IsTaxIncluded' => 'BOOLTYPE',
  'SalesTaxCodeRef ListID' => 'IDTYPE',
  'SalesTaxCodeRef FullName' => 'STRTYPE',
  'Other1' => 'STRTYPE',
  'Other2' => 'STRTYPE',
  'PurchaseOrderLineAdd ItemRef ListID' => 'IDTYPE',
  'PurchaseOrderLineAdd ItemRef FullName' => 'STRTYPE',
  'PurchaseOrderLineAdd ManufacturerPartNumber' => 'STRTYPE',
  'PurchaseOrderLineAdd Desc' => 'STRTYPE',
  'PurchaseOrderLineAdd Quantity' => 'QUANTYPE',
  'PurchaseOrderLineAdd UnitOfMeasure' => 'STRTYPE',
  'PurchaseOrderLineAdd Rate' => 'PRICETYPE',
  'PurchaseOrderLineAdd ClassRef ListID' => 'IDTYPE',
  'PurchaseOrderLineAdd ClassRef FullName' => 'STRTYPE',
  'PurchaseOrderLineAdd Amount' => 'AMTTYPE',
  'PurchaseOrderLineAdd CustomerRef ListID' => 'IDTYPE',
  'PurchaseOrderLineAdd CustomerRef FullName' => 'STRTYPE',
  'PurchaseOrderLineAdd ServiceDate' => 'DATETYPE',
  'PurchaseOrderLineAdd SalesTaxCodeRef ListID' => 'IDTYPE',
  'PurchaseOrderLineAdd SalesTaxCodeRef FullName' => 'STRTYPE',
  'PurchaseOrderLineAdd OverrideItemAccountRef ListID' => 'IDTYPE',
  'PurchaseOrderLineAdd OverrideItemAccountRef FullName' => 'STRTYPE',
  'PurchaseOrderLineAdd Other1' => 'STRTYPE',
  'PurchaseOrderLineAdd Other2' => 'STRTYPE',
  'PurchaseOrderLineAdd DataExt OwnerID' => 'GUIDTYPE',
  'PurchaseOrderLineAdd DataExt DataExtName' => 'STRTYPE',
  'PurchaseOrderLineAdd DataExt DataExtValue' => 'STRTYPE',
  'PurchaseOrderLineGroupAdd ItemGroupRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupAdd ItemGroupRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupAdd Desc' => 'STRTYPE',
  'PurchaseOrderLineGroupAdd Quantity' => 'QUANTYPE',
  'PurchaseOrderLineGroupAdd UnitOfMeasure' => 'STRTYPE',
  'PurchaseOrderLineGroupAdd ServiceDate' => 'DATETYPE',
  'PurchaseOrderLineGroupAdd DataExt OwnerID' => 'GUIDTYPE',
  'PurchaseOrderLineGroupAdd DataExt DataExtName' => 'STRTYPE',
  'PurchaseOrderLineGroupAdd DataExt DataExtValue' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'VendorRef ListID' => 0,
  'VendorRef FullName' => 41,
  'ClassRef ListID' => 0,
  'ClassRef FullName' => 41,
  'ShipToEntityRef ListID' => 0,
  'ShipToEntityRef FullName' => 41,
  'TemplateRef ListID' => 0,
  'TemplateRef FullName' => 41,
  'TxnDate' => 0,
  'RefNumber' => 11,
  'VendorAddress Addr1' => 41,
  'VendorAddress Addr2' => 41,
  'VendorAddress Addr3' => 41,
  'VendorAddress Addr4' => 41,
  'VendorAddress Addr5' => 41,
  'VendorAddress City' => 31,
  'VendorAddress State' => 21,
  'VendorAddress PostalCode' => 13,
  'VendorAddress Country' => 31,
  'VendorAddress Note' => 41,
  'ShipAddress Addr1' => 41,
  'ShipAddress Addr2' => 41,
  'ShipAddress Addr3' => 41,
  'ShipAddress Addr4' => 41,
  'ShipAddress Addr5' => 41,
  'ShipAddress City' => 31,
  'ShipAddress State' => 21,
  'ShipAddress PostalCode' => 13,
  'ShipAddress Country' => 31,
  'ShipAddress Note' => 41,
  'TermsRef ListID' => 0,
  'TermsRef FullName' => 41,
  'DueDate' => 0,
  'ExpectedDate' => 0,
  'ShipMethodRef ListID' => 0,
  'ShipMethodRef FullName' => 41,
  'FOB' => 13,
  'Memo' => 4095,
  'VendorMsg' => 99,
  'IsToBePrinted' => 0,
  'IsToBeEmailed' => 0,
  'IsTaxIncluded' => 0,
  'SalesTaxCodeRef ListID' => 0,
  'SalesTaxCodeRef FullName' => 41,
  'Other1' => 25,
  'Other2' => 29,
  'PurchaseOrderLineAdd ItemRef ListID' => 0,
  'PurchaseOrderLineAdd ItemRef FullName' => 41,
  'PurchaseOrderLineAdd ManufacturerPartNumber' => 31,
  'PurchaseOrderLineAdd Desc' => 4095,
  'PurchaseOrderLineAdd Quantity' => 0,
  'PurchaseOrderLineAdd UnitOfMeasure' => 31,
  'PurchaseOrderLineAdd Rate' => 0,
  'PurchaseOrderLineAdd ClassRef ListID' => 0,
  'PurchaseOrderLineAdd ClassRef FullName' => 41,
  'PurchaseOrderLineAdd Amount' => 0,
  'PurchaseOrderLineAdd CustomerRef ListID' => 0,
  'PurchaseOrderLineAdd CustomerRef FullName' => 41,
  'PurchaseOrderLineAdd ServiceDate' => 0,
  'PurchaseOrderLineAdd SalesTaxCodeRef ListID' => 0,
  'PurchaseOrderLineAdd SalesTaxCodeRef FullName' => 41,
  'PurchaseOrderLineAdd OverrideItemAccountRef ListID' => 0,
  'PurchaseOrderLineAdd OverrideItemAccountRef FullName' => 41,
  'PurchaseOrderLineAdd Other1' => 25,
  'PurchaseOrderLineAdd Other2' => 29,
  'PurchaseOrderLineAdd DataExt OwnerID' => 0,
  'PurchaseOrderLineAdd DataExt DataExtName' => 31,
  'PurchaseOrderLineAdd DataExt DataExtValue' => 0,
  'PurchaseOrderLineGroupAdd ItemGroupRef ListID' => 0,
  'PurchaseOrderLineGroupAdd ItemGroupRef FullName' => 41,
  'PurchaseOrderLineGroupAdd Desc' => 4095,
  'PurchaseOrderLineGroupAdd Quantity' => 0,
  'PurchaseOrderLineGroupAdd UnitOfMeasure' => 31,
  'PurchaseOrderLineGroupAdd ServiceDate' => 0,
  'PurchaseOrderLineGroupAdd DataExt OwnerID' => 0,
  'PurchaseOrderLineGroupAdd DataExt DataExtName' => 31,
  'PurchaseOrderLineGroupAdd DataExt DataExtValue' => 0,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'VendorRef ListID' => true,
  'VendorRef FullName' => true,
  'ClassRef ListID' => true,
  'ClassRef FullName' => true,
  'ShipToEntityRef ListID' => true,
  'ShipToEntityRef FullName' => true,
  'TemplateRef ListID' => true,
  'TemplateRef FullName' => true,
  'TxnDate' => true,
  'RefNumber' => true,
  'VendorAddress Addr1' => true,
  'VendorAddress Addr2' => true,
  'VendorAddress Addr3' => true,
  'VendorAddress Addr4' => true,
  'VendorAddress Addr5' => true,
  'VendorAddress City' => true,
  'VendorAddress State' => true,
  'VendorAddress PostalCode' => true,
  'VendorAddress Country' => true,
  'VendorAddress Note' => true,
  'ShipAddress Addr1' => true,
  'ShipAddress Addr2' => true,
  'ShipAddress Addr3' => true,
  'ShipAddress Addr4' => true,
  'ShipAddress Addr5' => true,
  'ShipAddress City' => true,
  'ShipAddress State' => true,
  'ShipAddress PostalCode' => true,
  'ShipAddress Country' => true,
  'ShipAddress Note' => true,
  'TermsRef ListID' => true,
  'TermsRef FullName' => true,
  'DueDate' => true,
  'ExpectedDate' => true,
  'ShipMethodRef ListID' => true,
  'ShipMethodRef FullName' => true,
  'FOB' => true,
  'Memo' => true,
  'VendorMsg' => true,
  'IsToBePrinted' => true,
  'IsToBeEmailed' => true,
  'IsTaxIncluded' => true,
  'SalesTaxCodeRef ListID' => true,
  'SalesTaxCodeRef FullName' => true,
  'Other1' => true,
  'Other2' => true,
  'PurchaseOrderLineAdd ItemRef ListID' => true,
  'PurchaseOrderLineAdd ItemRef FullName' => true,
  'PurchaseOrderLineAdd ManufacturerPartNumber' => true,
  'PurchaseOrderLineAdd Desc' => true,
  'PurchaseOrderLineAdd Quantity' => true,
  'PurchaseOrderLineAdd UnitOfMeasure' => true,
  'PurchaseOrderLineAdd Rate' => true,
  'PurchaseOrderLineAdd ClassRef ListID' => true,
  'PurchaseOrderLineAdd ClassRef FullName' => true,
  'PurchaseOrderLineAdd Amount' => true,
  'PurchaseOrderLineAdd CustomerRef ListID' => true,
  'PurchaseOrderLineAdd CustomerRef FullName' => true,
  'PurchaseOrderLineAdd ServiceDate' => true,
  'PurchaseOrderLineAdd SalesTaxCodeRef ListID' => true,
  'PurchaseOrderLineAdd SalesTaxCodeRef FullName' => true,
  'PurchaseOrderLineAdd OverrideItemAccountRef ListID' => true,
  'PurchaseOrderLineAdd OverrideItemAccountRef FullName' => true,
  'PurchaseOrderLineAdd Other1' => true,
  'PurchaseOrderLineAdd Other2' => true,
  'PurchaseOrderLineAdd DataExt OwnerID' => false,
  'PurchaseOrderLineAdd DataExt DataExtName' => false,
  'PurchaseOrderLineAdd DataExt DataExtValue' => false,
  'PurchaseOrderLineGroupAdd ItemGroupRef ListID' => true,
  'PurchaseOrderLineGroupAdd ItemGroupRef FullName' => true,
  'PurchaseOrderLineGroupAdd Desc' => true,
  'PurchaseOrderLineGroupAdd Quantity' => true,
  'PurchaseOrderLineGroupAdd UnitOfMeasure' => true,
  'PurchaseOrderLineGroupAdd ServiceDate' => true,
  'PurchaseOrderLineGroupAdd DataExt OwnerID' => false,
  'PurchaseOrderLineGroupAdd DataExt DataExtName' => false,
  'PurchaseOrderLineGroupAdd DataExt DataExtValue' => false,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'VendorRef ListID' => 999.99,
  'VendorRef FullName' => 999.99,
  'ClassRef ListID' => 999.99,
  'ClassRef FullName' => 999.99,
  'ShipToEntityRef ListID' => 999.99,
  'ShipToEntityRef FullName' => 999.99,
  'TemplateRef ListID' => 999.99,
  'TemplateRef FullName' => 999.99,
  'TxnDate' => 999.99,
  'RefNumber' => 999.99,
  'VendorAddress Addr1' => 999.99,
  'VendorAddress Addr2' => 999.99,
  'VendorAddress Addr3' => 999.99,
  'VendorAddress Addr4' => 2,
  'VendorAddress Addr5' => 6,
  'VendorAddress City' => 999.99,
  'VendorAddress State' => 999.99,
  'VendorAddress PostalCode' => 999.99,
  'VendorAddress Country' => 999.99,
  'VendorAddress Note' => 6,
  'ShipAddress Addr1' => 999.99,
  'ShipAddress Addr2' => 999.99,
  'ShipAddress Addr3' => 999.99,
  'ShipAddress Addr4' => 2,
  'ShipAddress Addr5' => 6,
  'ShipAddress City' => 999.99,
  'ShipAddress State' => 999.99,
  'ShipAddress PostalCode' => 999.99,
  'ShipAddress Country' => 999.99,
  'ShipAddress Note' => 6,
  'TermsRef ListID' => 999.99,
  'TermsRef FullName' => 999.99,
  'DueDate' => 999.99,
  'ExpectedDate' => 999.99,
  'ShipMethodRef ListID' => 999.99,
  'ShipMethodRef FullName' => 999.99,
  'FOB' => 999.99,
  'Memo' => 999.99,
  'VendorMsg' => 999.99,
  'IsToBePrinted' => 999.99,
  'IsToBeEmailed' => 6,
  'IsTaxIncluded' => 6,
  'SalesTaxCodeRef ListID' => 999.99,
  'SalesTaxCodeRef FullName' => 999.99,
  'Other1' => 6,
  'Other2' => 6,
  'PurchaseOrderLineAdd ItemRef ListID' => 999.99,
  'PurchaseOrderLineAdd ItemRef FullName' => 999.99,
  'PurchaseOrderLineAdd ManufacturerPartNumber' => 7,
  'PurchaseOrderLineAdd Desc' => 999.99,
  'PurchaseOrderLineAdd Quantity' => 999.99,
  'PurchaseOrderLineAdd UnitOfMeasure' => 7,
  'PurchaseOrderLineAdd Rate' => 999.99,
  'PurchaseOrderLineAdd ClassRef ListID' => 999.99,
  'PurchaseOrderLineAdd ClassRef FullName' => 999.99,
  'PurchaseOrderLineAdd Amount' => 999.99,
  'PurchaseOrderLineAdd CustomerRef ListID' => 999.99,
  'PurchaseOrderLineAdd CustomerRef FullName' => 999.99,
  'PurchaseOrderLineAdd ServiceDate' => 999.99,
  'PurchaseOrderLineAdd SalesTaxCodeRef ListID' => 999.99,
  'PurchaseOrderLineAdd SalesTaxCodeRef FullName' => 999.99,
  'PurchaseOrderLineAdd OverrideItemAccountRef ListID' => 999.99,
  'PurchaseOrderLineAdd OverrideItemAccountRef FullName' => 999.99,
  'PurchaseOrderLineAdd Other1' => 6,
  'PurchaseOrderLineAdd Other2' => 6,
  'PurchaseOrderLineAdd DataExt OwnerID' => 999.99,
  'PurchaseOrderLineAdd DataExt DataExtName' => 999.99,
  'PurchaseOrderLineAdd DataExt DataExtValue' => 999.99,
  'PurchaseOrderLineGroupAdd ItemGroupRef ListID' => 999.99,
  'PurchaseOrderLineGroupAdd ItemGroupRef FullName' => 999.99,
  'PurchaseOrderLineGroupAdd Desc' => 999.99,
  'PurchaseOrderLineGroupAdd Quantity' => 999.99,
  'PurchaseOrderLineGroupAdd UnitOfMeasure' => 7,
  'PurchaseOrderLineGroupAdd ServiceDate' => 999.99,
  'PurchaseOrderLineGroupAdd DataExt OwnerID' => 999.99,
  'PurchaseOrderLineGroupAdd DataExt DataExtName' => 999.99,
  'PurchaseOrderLineGroupAdd DataExt DataExtValue' => 999.99,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'VendorRef ListID' => false,
  'VendorRef FullName' => false,
  'ClassRef ListID' => false,
  'ClassRef FullName' => false,
  'ShipToEntityRef ListID' => false,
  'ShipToEntityRef FullName' => false,
  'TemplateRef ListID' => false,
  'TemplateRef FullName' => false,
  'TxnDate' => false,
  'RefNumber' => false,
  'VendorAddress Addr1' => false,
  'VendorAddress Addr2' => false,
  'VendorAddress Addr3' => false,
  'VendorAddress Addr4' => false,
  'VendorAddress Addr5' => false,
  'VendorAddress City' => false,
  'VendorAddress State' => false,
  'VendorAddress PostalCode' => false,
  'VendorAddress Country' => false,
  'VendorAddress Note' => false,
  'ShipAddress Addr1' => false,
  'ShipAddress Addr2' => false,
  'ShipAddress Addr3' => false,
  'ShipAddress Addr4' => false,
  'ShipAddress Addr5' => false,
  'ShipAddress City' => false,
  'ShipAddress State' => false,
  'ShipAddress PostalCode' => false,
  'ShipAddress Country' => false,
  'ShipAddress Note' => false,
  'TermsRef ListID' => false,
  'TermsRef FullName' => false,
  'DueDate' => false,
  'ExpectedDate' => false,
  'ShipMethodRef ListID' => false,
  'ShipMethodRef FullName' => false,
  'FOB' => false,
  'Memo' => false,
  'VendorMsg' => false,
  'IsToBePrinted' => false,
  'IsToBeEmailed' => false,
  'IsTaxIncluded' => false,
  'SalesTaxCodeRef ListID' => false,
  'SalesTaxCodeRef FullName' => false,
  'Other1' => false,
  'Other2' => false,
  'PurchaseOrderLineAdd ItemRef ListID' => false,
  'PurchaseOrderLineAdd ItemRef FullName' => false,
  'PurchaseOrderLineAdd ManufacturerPartNumber' => false,
  'PurchaseOrderLineAdd Desc' => false,
  'PurchaseOrderLineAdd Quantity' => false,
  'PurchaseOrderLineAdd UnitOfMeasure' => false,
  'PurchaseOrderLineAdd Rate' => false,
  'PurchaseOrderLineAdd ClassRef ListID' => false,
  'PurchaseOrderLineAdd ClassRef FullName' => false,
  'PurchaseOrderLineAdd Amount' => false,
  'PurchaseOrderLineAdd CustomerRef ListID' => false,
  'PurchaseOrderLineAdd CustomerRef FullName' => false,
  'PurchaseOrderLineAdd ServiceDate' => false,
  'PurchaseOrderLineAdd SalesTaxCodeRef ListID' => false,
  'PurchaseOrderLineAdd SalesTaxCodeRef FullName' => false,
  'PurchaseOrderLineAdd OverrideItemAccountRef ListID' => false,
  'PurchaseOrderLineAdd OverrideItemAccountRef FullName' => false,
  'PurchaseOrderLineAdd Other1' => false,
  'PurchaseOrderLineAdd Other2' => false,
  'PurchaseOrderLineAdd DataExt OwnerID' => false,
  'PurchaseOrderLineAdd DataExt DataExtName' => false,
  'PurchaseOrderLineAdd DataExt DataExtValue' => false,
  'PurchaseOrderLineGroupAdd ItemGroupRef ListID' => false,
  'PurchaseOrderLineGroupAdd ItemGroupRef FullName' => false,
  'PurchaseOrderLineGroupAdd Desc' => false,
  'PurchaseOrderLineGroupAdd Quantity' => false,
  'PurchaseOrderLineGroupAdd UnitOfMeasure' => false,
  'PurchaseOrderLineGroupAdd ServiceDate' => false,
  'PurchaseOrderLineGroupAdd DataExt OwnerID' => false,
  'PurchaseOrderLineGroupAdd DataExt DataExtName' => false,
  'PurchaseOrderLineGroupAdd DataExt DataExtValue' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'VendorRef ListID',
  1 => 'VendorRef FullName',
  2 => 'ClassRef ListID',
  3 => 'ClassRef FullName',
  4 => 'ShipToEntityRef ListID',
  5 => 'ShipToEntityRef FullName',
  6 => 'TemplateRef ListID',
  7 => 'TemplateRef FullName',
  8 => 'TxnDate',
  9 => 'RefNumber',
  10 => 'VendorAddress Addr1',
  11 => 'VendorAddress Addr2',
  12 => 'VendorAddress Addr3',
  13 => 'VendorAddress Addr4',
  14 => 'VendorAddress Addr5',
  15 => 'VendorAddress City',
  16 => 'VendorAddress State',
  17 => 'VendorAddress PostalCode',
  18 => 'VendorAddress Country',
  19 => 'VendorAddress Note',
  20 => 'ShipAddress Addr1',
  21 => 'ShipAddress Addr2',
  22 => 'ShipAddress Addr3',
  23 => 'ShipAddress Addr4',
  24 => 'ShipAddress Addr5',
  25 => 'ShipAddress City',
  26 => 'ShipAddress State',
  27 => 'ShipAddress PostalCode',
  28 => 'ShipAddress Country',
  29 => 'ShipAddress Note',
  30 => 'TermsRef ListID',
  31 => 'TermsRef FullName',
  32 => 'DueDate',
  33 => 'ExpectedDate',
  34 => 'ShipMethodRef ListID',
  35 => 'ShipMethodRef FullName',
  36 => 'FOB',
  37 => 'Memo',
  38 => 'VendorMsg',
  39 => 'IsToBePrinted',
  40 => 'IsToBeEmailed',
  41 => 'IsTaxIncluded',
  42 => 'SalesTaxCodeRef ListID',
  43 => 'SalesTaxCodeRef FullName',
  44 => 'Other1',
  45 => 'Other2',
  46 => 'PurchaseOrderLineAdd',
  47 => 'PurchaseOrderLineAdd ItemRef',
  48 => 'PurchaseOrderLineAdd ItemRef ListID',
  49 => 'PurchaseOrderLineAdd ItemRef FullName',
  50 => 'PurchaseOrderLineAdd ManufacturerPartNumber',
  51 => 'PurchaseOrderLineAdd Desc',
  52 => 'PurchaseOrderLineAdd Quantity',
  53 => 'PurchaseOrderLineAdd UnitOfMeasure',
  54 => 'PurchaseOrderLineAdd Rate',
  55 => 'PurchaseOrderLineAdd ClassRef ListID',
  56 => 'PurchaseOrderLineAdd ClassRef FullName',
  57 => 'PurchaseOrderLineAdd Amount',
  58 => 'PurchaseOrderLineAdd CustomerRef ListID',
  59 => 'PurchaseOrderLineAdd CustomerRef FullName',
  60 => 'PurchaseOrderLineAdd ServiceDate',
  61 => 'PurchaseOrderLineAdd SalesTaxCodeRef ListID',
  62 => 'PurchaseOrderLineAdd SalesTaxCodeRef FullName',
  63 => 'PurchaseOrderLineAdd OverrideItemAccountRef ListID',
  64 => 'PurchaseOrderLineAdd OverrideItemAccountRef FullName',
  65 => 'PurchaseOrderLineAdd Other1',
  66 => 'PurchaseOrderLineAdd Other2',
  67 => 'PurchaseOrderLineAdd DataExt OwnerID',
  68 => 'PurchaseOrderLineAdd DataExt DataExtName',
  69 => 'PurchaseOrderLineAdd DataExt DataExtValue',
  70 => 'PurchaseOrderLineGroupAdd ItemGroupRef ListID',
  71 => 'PurchaseOrderLineGroupAdd ItemGroupRef FullName',
  72 => 'PurchaseOrderLineGroupAdd Desc',
  73 => 'PurchaseOrderLineGroupAdd Quantity',
  74 => 'PurchaseOrderLineGroupAdd UnitOfMeasure',
  75 => 'PurchaseOrderLineGroupAdd ServiceDate',
  76 => 'PurchaseOrderLineGroupAdd DataExt OwnerID',
  77 => 'PurchaseOrderLineGroupAdd DataExt DataExtName',
  78 => 'PurchaseOrderLineGroupAdd DataExt DataExtValue',
  79 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>