<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

function wh_add_tokens_to_table($realm_id, $access_token, $refresh_token) {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $delete = $wpdb->query("TRUNCATE TABLE ".$table_name."");
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'realm_id',
      'value' => $realm_id
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'access_token',
      'value' => $access_token
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'refresh_token',
      'value' => $refresh_token
    )
  );
}

function refresh_tokens($access_token, $refresh_token) {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $realmId = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'realm_id' ");
  $delete = $wpdb->query("TRUNCATE TABLE ".$table_name."");
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'realm_id',
      'value' => $realmId
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'access_token',
      'value' => $access_token
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'refresh_token',
      'value' => $refresh_token
    )
  );
}

function wh_add_stats_to_table($qbProducts, $updatedProducts, $newProducts, $noSkuProducts) {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_stats';
  $delete = $wpdb->query("TRUNCATE TABLE $table_name");
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'qb_products',
      'value' => $qbProducts,
      'time' => time()
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'updated_products',
      'value' => $updatedProducts,
      'time' => time()
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'new_products',
      'value' => $newProducts,
      'time' => time()
    )
  );
  $wpdb->insert(
    $table_name,
    array(
      'name' => 'no_sku_products',
      'value' => $noSkuProducts,
      'time' => time()
    )
  );
}

function sec2hms ($sec, $padHours = false) 
{
  $now = time();
  $then = $sec;
  $sec = $now - $then;

  // do the hours first: there are 3600 seconds in an hour, so if we divide
  // the total number of seconds by 3600 and throw away the remainder, we're
  // left with the number of hours in those seconds
  $hours = intval(intval($sec) / 3600); 

  // start our return string with the hours (with a leading 0 if asked for)
  if ($padHours) {
    $hms = str_pad($hours, 2, "0", STR_PAD_LEFT). ":";
  } else {
    $hms = $hours. ":";
  }

  // dividing the total seconds by 60 will give us the number of minutes
  // in total, but we're interested in *minutes past the hour* and to get
  // this, we have to divide by 60 again and then use the remainder
  $minutes = intval(($sec / 60) % 60); 

  // add minutes to $hms (with a leading 0 if needed)
  $hms .= str_pad($minutes, 2, "0", STR_PAD_LEFT). ":";

  // seconds past the minute are found by dividing the total number of seconds
  // by 60 and using the remainder
  $seconds = intval($sec % 60); 

  // add seconds to $hms (with a leading 0 if needed)
  $hms .= str_pad($seconds, 2, "0", STR_PAD_LEFT);

  // done!
  return $hms;

}