<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

// Welcome page
require_once plugin_dir_path( __FILE__ ) . 'pages/welcome.php';

// oauth2 pages
require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/index.php';
require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/oauth2.php';
require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/refresh_token.php';
require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/clear_session.php';

require_once plugin_dir_path( __FILE__ ) . 'pages/test.php';

// Add admin menu pages action
add_action('admin_menu', 'whq_add_main_page');
add_action('admin_menu', 'whq_add_oauth2_pages');

// Add main menu pages function
function whq_add_main_page() {
  add_menu_page(__('QuickBooks Sync','menu-whq'), __('QuickBooks Sync','menu-whq'), 'manage_options', 'welcome', 'welcome_page', 'dashicons-update', '26');
}

// Add oauth2 menu pages function
function whq_add_oauth2_pages() {
  add_submenu_page('welcome', __('Connect', 'menu-whq'), __('Connect', 'menu-whq'), 'manage_options', 'connect', 'connect_page');
  add_submenu_page('connect', __('OAuth2', 'menu-whq'), __('OAuth2', 'menu-whq'), 'manage_options', 'oauth2', 'oauth2_page');
  add_submenu_page('connect', __('Refresh Token', 'menu-whq'), __('Refresh Token', 'menu-whq'), 'manage_options', 'refresh-token', 'refreshToken_page');
  add_submenu_page('connect', __('Clear Session', 'menu-whq'), __('Clear Session', 'menu-whq'), 'manage_options', 'clear-session', 'clearSession_page');
}
