<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

function wh_cron_up_deactivate() {
  $timestamp = wp_next_scheduled( 'wh_update_products' );
  wp_unschedule_event( $timestamp, 'wh_update_products' );
}
function wh_cron_up_activate() {
  if ( !wp_next_scheduled( 'wh_update_products' ) ) {
    wp_schedule_event( time(), 'every_five_minutes', 'wh_update_products' );
  }
}

function wh_cron_rt_deactivate() {
  $timestamp = wp_next_scheduled( 'wh_refresh_token' );
  wp_unschedule_event( $timestamp, 'wh_refresh_token' );
}
function wh_cron_rt_activate() {
  if ( !wp_next_scheduled( 'wh_refresh_token' ) ) {
    wp_schedule_event( time(), 'every_one_minute', 'wh_refresh_token' );
  }
}
