<?php

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

function wh_token_to_refresh() {
  $file = plugin_dir_path( __FILE__ ) . 'blabla.txt';
  $flags = FILE_APPEND | LOCK_EX;
  file_put_contents($file, "\r\n----\r\nstarted refresh token at " . date('D M d H:i:s') . "\r\n", $flags);

  require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/client.php';
  $configs = require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/config.php';

  $tokenEndPointUrl = $configs['tokenEndPointUrl'];
  $mainPage = $configs['mainPage'];
  $client_id = $configs['client_id'];
  $client_secret = $configs['client_secret'];

  $grant_type = 'refresh_token';

  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $refresh_token = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'refresh_token' ");

  $client = new Client($client_id, $client_secret);
  $result = $client->refreshAccessToken($tokenEndPointUrl, $grant_type, $refresh_token);
  if ($result['access_token'] != NULL) {
    file_put_contents($file, "\r\n access token found in result! will proceed with refresh_token function\r\n", $flags);
    refresh_tokens($result['access_token'], $result['refresh_token']);
  } else {
    file_put_contents($file, "\r\n access token is not found in result! will not proceed with refresh_token function\r\n", $flags);
  }

  file_put_contents($file, error_get_last(), $flags);
  file_put_contents($file, "\r\nended refresh token at " . date('D M d H:i:s') . "\r\n----\r\n", $flags);
}
