<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\Core\ServiceContext;
use QuickBooksOnline\API\PlatformService\PlatformService;
use QuickBooksOnline\API\Utility\Configuration\ConfigurationManager;

function wh_products_to_update() {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';

  $file = plugin_dir_path( __FILE__ ) . 'blabla.txt';
  $flags = FILE_APPEND | LOCK_EX;
  file_put_contents($file, "\r\n----\r\nstarted update at " . date('D M d H:i:s') . "\r\n", $flags);

  $configs = require_once plugin_dir_path( __FILE__ ) . 'pages/oauth2/config.php';
  $clientId = $configs['client_id'];
  $clientSecret = $configs['client_secret'];
  $baseUrl = $configs['baseUrl'];
  $accessToken = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'access_token' ");
  $refreshToken = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'refresh_token' ");
  $realmId = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'realm_id' ");

  try {
    $dataService = DataService::Configure(array(
      'auth_mode' => 'oauth2',
      'ClientID' => $clientId,
      'ClientSecret' => $clientSecret,
      'accessTokenKey' =>  $accessToken,
      'refreshTokenKey' => $refreshToken,
      'QBORealmID' => $realmId,
      'baseUrl' => "https://quickbooks.api.intuit.com/"
    ));
  } catch (Exception $e) {
    file_put_contents($file, $e->getMessage(), $flags);
    echo 'Caught exception: ',  $e->getMessage(), "\n";
  }
  // $dataService = DataService::Configure(array(
  //   'auth_mode' => 'oauth2',
  //   'ClientID' => $clientId,
  //   'ClientSecret' => $clientSecret,
  //   'accessTokenKey' =>  $accessToken,
  //   'refreshTokenKey' => $refreshToken,
  //   'QBORealmID' => $realmId,
  //   'baseUrl' => $baseUrl
  // ));
  $entities = $dataService->Query("SELECT * FROM Item STARTPOSITION 1 MAXRESULTS 1000");
  $qbProducts = count($entities);
  echo "Total number of items: ";
  echo count($entities);
  echo "\n";

  $filesCount = 0;
  $updatedProducts = 0;
  $newProducts = 0;
  $noSkuProducts = 0;

  foreach ((array) $entities as $entitie) {
    $filesCount += 1;

    // var_dump($entitie);
    $qb_name = $entitie->Name;
    $qb_sku = $entitie->Sku;
    $qb_price = $entitie->UnitPrice;
    $qb_quantity = $entitie->QtyOnHand;
    if ((int)$qb_quantity > 0) {
      $qb_stock = 'instock';
    } else {
      $qb_stock = 'outofstock';
    }

    $updateProductArr = array(
      "post_type" => "product",
      // "post_status" => "publish",
      "meta_input" => array(
        "_price" => $qb_price,
        "_regular_price" => $qb_price,
        "_ls_sell_price" => $qb_price,
        "_stock" => $qb_quantity,
        "_stock_status" => $qb_stock,
        "_manage_stock" => "yes"
      )
    );

    $addProductArr = array(
      "post_author" => 1,
      "post_title" => $qb_name,
      "post_status"   => "draft",
      "post_type"     => "product",
      "meta_input"    => array(
        "_sku" => $qb_sku,
        "_price" => $qb_price,
        "_regular_price" => $qb_price,
        "_ls_sell_price" => $qb_price,
        "_stock" => $qb_quantity,
        "_stock_status" => $qb_stock,
        "_manage_stock" => "yes"
      )
    );

    $args = array(
      "post_type"      => "product",
      "post_status"    => "any",
      "posts_per_page" => -1,
      "meta_query"     => array(
        array(
          "key"     => "_sku",
          "value"	  => $qb_sku,
            "compare" => "="
        )
      )
    );

    $my_query = new WP_Query( $args );
    if ( $my_query->have_posts() ) {
      while ( $my_query->have_posts() ) {
        $my_query->the_post();
        $the_post_id = get_the_id();
        $meta = get_post_meta($the_post_id);
        $sku = $meta['_sku'][0];
        // var_dump($meta);
        if ($qb_sku == $sku) {
          $updateProductArr["ID"] = $the_post_id;
          $upID = wp_update_post($updateProductArr);
          $updatedProducts += 1;
        }
      }
    } else {
      // var_dump($qb_sku);
      if ($qb_sku != NULL) {
        $pId = wp_insert_post($addProductArr);
        $newProducts += 1;
      } else {
        $noSkuProducts += 1;
      }
    }
    wp_reset_postdata();
  }
  wh_add_stats_to_table($qbProducts, $updatedProducts, $newProducts, $noSkuProducts);
  file_put_contents($file, "\r\n" . $filesCount . " looped files\r\n", $flags);
  file_put_contents($file, "\r\n" . $updatedProducts . " were updated\r\n", $flags);
  file_put_contents($file, "\r\n" . $newProducts . " new posts added\r\n", $flags);
  file_put_contents($file, "\r\n" . $noSkuProducts . " posts not added because they are without sku\r\n", $flags);
  file_put_contents($file, error_get_last(), $flags);
  file_put_contents($file, "\r\nended update at " . date('D M d H:i:s') . "\r\n----\r\n", $flags);
}
