<?php
add_action( 'after_setup_theme', 'blankslate_setup' );
function blankslate_setup()
{
load_theme_textdomain( 'blankslate', get_template_directory() . '/languages' );
add_theme_support( 'title-tag' );
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'post-thumbnails' );
global $content_width;
if ( ! isset( $content_width ) ) $content_width = 640;
register_nav_menus(
array( 'main-menu' => __( 'Main Menu', 'blankslate' ) )
);
}
add_action( 'wp_enqueue_scripts', 'blankslate_load_scripts' );
function blankslate_load_scripts()
{
wp_enqueue_script( 'jquery' );
}
add_action( 'comment_form_before', 'blankslate_enqueue_comment_reply_script' );
function blankslate_enqueue_comment_reply_script()
{
if ( get_option( 'thread_comments' ) ) { wp_enqueue_script( 'comment-reply' ); }
}
add_filter( 'the_title', 'blankslate_title' );
function blankslate_title( $title ) {
if ( $title == '' ) {
return '&rarr;';
} else {
return $title;
}
}
add_filter( 'wp_title', 'blankslate_filter_wp_title' );
function blankslate_filter_wp_title( $title )
{
return $title . esc_attr( get_bloginfo( 'name' ) );
}
add_action( 'widgets_init', 'blankslate_widgets_init' );
function blankslate_widgets_init()
{
register_sidebar( array (
'name' => __( 'Sidebar Widget Area', 'blankslate' ),
'id' => 'primary-widget-area',
'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
'after_widget' => "</li>",
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
}
function blankslate_custom_pings( $comment )
{
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>"><?php echo comment_author_link(); ?></li>
<?php 
}
add_filter( 'get_comments_number', 'blankslate_comments_number' );
function blankslate_comments_number( $count )
{
if ( !is_admin() ) {
global $id;
$comments_by_type = &separate_comments( get_comments( 'status=approve&post_id=' . $id ) );
return count( $comments_by_type['comment'] );
} else {
return $count;
}
}

//-----------------------------------------------------
// Include js file for back to top
//-----------------------------------------------------

function wpb_adding_scripts() {
  wp_register_script('smoothup', get_template_directory_uri() . '/js/smoothscroll.js', array('jquery'), '1.1', true);
  wp_enqueue_script('smoothup');
}
add_action( 'wp_enqueue_scripts', 'wpb_adding_scripts' );
// wp_enqueue_script( 'script', get_template_directory_uri() . '/js/script.js', array ( 'jquery' ), 1.1, true);

//-----------------------------------------------------
// Gallery lightbox 
//-----------------------------------------------------

add_action( 'after_setup_theme', 'yourtheme_setup' );
 
function yourtheme_setup() {
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );
}
//-----------------------------------------------------
// Set products per page
//-----------------------------------------------------

add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );

function new_loop_shop_per_page( $cols ) {
  // $cols contains the current number of products per page based on the value stored on Options -> Reading
  // Return the number of products you wanna show per page.
  $cols = 8;
  return $cols;
}

//-----------------------------------------------------
// Change # in stock completely
//-----------------------------------------------------
 
add_filter( 'woocommerce_get_availability', 'custom_get_availability', 1, 2);
 
function custom_get_availability( $availability, $_product ) {
  global $product;
  $stock = $product->get_total_stock();
 
  if ( $_product->is_in_stock() ) $availability['availability'] = __('Available in Stock ' . $stock, 'woocommerce');
 
 
  return $availability;
}

// Registers the new post type and taxonomy start

function wpt_deal_posttype() {
	register_post_type( 'deals',
		array(
			'labels' => array(
				'name' => __( 'Deals' ),
				'singular_name' => __( 'Deal' ),
				'add_new' => __( 'Add New Deal' ),
				'add_new_item' => __( 'Add New Deal' ),
				'edit_item' => __( 'Edit Deal' ),
				'new_item' => __( 'Add New Deal' ),
				'view_item' => __( 'View Deal' ),
				'search_items' => __( 'Search Deal' ),
				'not_found' => __( 'No deals found' ),
				'not_found_in_trash' => __( 'No deals found in trash' )
			),
			'public' => true,
			'supports' => array( 'title', 'editor', 'thumbnail', 'custom-fields'),
			'capability_type' => 'post',
			'rewrite' => array("slug" => "deals"), // Permalinks format
			'menu_position' => 5,
			'menu_icon' => 'dashicons-portfolio'
		)
	);
}

add_action( 'init', 'wpt_deal_posttype' );


// Add html5 theme support 
add_theme_support('html5', array('search-form'));

// Improving WordPress' the_excerpt() template tag

function improved_trim_excerpt($text) {
	global $post;
	if ( '' == $text ) {
		$text = get_the_content('');
		$text = strip_tags($text, '<p>');
		$excerpt_length = 23;
		$words = explode(' ', $text, $excerpt_length + 1);
		if (count($words)> $excerpt_length) {
			array_pop($words);
			array_push($words, '[...]');
			$text = implode(' ', $words);
		}
	}
	return $text;
}
remove_filter('get_the_excerpt', 'wp_trim_excerpt');
add_filter('get_the_excerpt', 'improved_trim_excerpt');

// Disable WordPress Theme Update Notifications

remove_action( 'load-update-core.php', 'wp_update_themes' );
add_filter( 'pre_site_transient_update_themes', '__return_null' );
wp_clear_scheduled_hook( 'wp_update_themes' );

// Next and Prev on services

// function to find location within array
function relative_value_array($array, $current_val = '', $offset = 1) {
  $values = array_values($array);
  $current_val_index = array_search($current_val, $values);

  if( isset($values[$current_val_index + $offset]) ) {
    return $values[$current_val_index + $offset];
  }
  return false;
};

// previous page link function
function dbdb_prev_page_link() {
  global $post;

  if ( isset($post->post_parent) && $post->post_parent > 0 ) {
    $children = get_pages('&sort_column=menu_order&sort_order=asc&child_of='.$post->post_parent.'&parent='.$post->post_parent);
  };

  // throw the children ids into an array
  if ($children) {
    foreach( $children as $child ) { $child_id_array[] = $child->ID; }
  }

  $prev_page_id = relative_value_array($child_id_array, $post->ID, -1);

  $output = '';
  if ( '' != $prev_page_id ) {
    $output .= '<a href="' . get_page_link($prev_page_id) . '"> &laquo; '. get_the_title($prev_page_id) . '</a>';
  }
  return $output;
};

//next page link function
function dbdb_next_page_link() {
  global $post;

  if ( isset($post->post_parent) && $post->post_parent > 0 ) {
    $children = get_pages('&sort_column=menu_order&sort_order=asc&child_of='.$post->post_parent.'&parent='.$post->post_parent);
  };

  // throw the children ids into an array
  if ($children) {
    foreach( $children as $child ) { $child_id_array[] = $child->ID; }
  }

  $next_page_id = relative_value_array($child_id_array, $post->ID, 1);

  $output = '';
  if( '' != $next_page_id ) {
    $output .= '<a href="' . get_page_link($next_page_id) . '">'. get_the_title($next_page_id) . ' &raquo;</a>';
  }
  return $output;
};
add_filter( 'woocommerce_prevent_admin_access', '__return_false' );
add_filter( 'woocommerce_disable_admin_bar', '__return_false');
function custom_menu_page_removing() {
	remove_menu_page('vc-welcome'); //vc
}
add_action( 'admin_init', 'custom_menu_page_removing' );





/*add_action( 'pre_get_posts', 'iconic_hide_out_of_stock_products' );

function iconic_hide_out_of_stock_products( $q ) {

  if ( $q->is_main_query() && !$q->is_page() && !is_single() && !is_admin() ) {
    $meta_query = (array) $q->get('meta_query');
  
    $meta_query[] = array(
      'key'       => '_stock_status',
      'value'     => 'outofstock',
      'compare'   => 'NOT IN'
    );
      
    $q->set( 'meta_query', $meta_query );
    var_dump($q->get('meta_query'));
  
    remove_action( 'pre_get_posts', 'iconic_hide_out_of_stock_products' );
  } else {
    return;
  }

}
?>
*/
add_action( 'pre_get_posts', 'iconic_hide_out_of_stock_products' );

function iconic_hide_out_of_stock_products( $q ) {

    if ( ! $q->is_main_query() ) return;
    if ( $q->is_page() ) return;
    if ( is_admin() ) return;

    $meta_query = (array) $q->get('meta_query');

    $meta_query[] = array(
        'key'       => '_stock_status',
        'value'     => 'outofstock',
        'compare'   => 'NOT IN'
    );

    $q->set( 'meta_query', $meta_query );

    remove_action( 'pre_get_posts', 'iconic_hide_out_of_stock_products' );

}