<?php get_header(); ?>
<section id="content" role="main">
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<header class="header">
<h1 class="entry-title"><?php the_title(); ?></h1> <?php edit_post_link(); ?>
</header>
<section class="entry-content">
<?php if ( is_user_logged_in() ) : ?>
    <?php if ( has_post_thumbnail() ) { the_post_thumbnail(); } ?>
    <?php the_content(); ?>
    <div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
            <div class="vc_column-inner ">
                <div class="wpb_wrapper">
                    <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
                        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.steer&quot;).trigger(&quot;sorton&quot;, [ [[0,0]] ]);">Sort by Name</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-4">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.steer&quot;).trigger(&quot;sorton&quot;, [ [[3,0]] ]);">Sort by Size</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <table id="inventory" class="inventory steer">
        <thead>
            <tr>
                <th class="title column">Steer Tires</th>
                <th class="{sorter: false} brand column">Brand</th>
                <th class="{sorter: false} model column">Model</th>
                <th class="size column">Size</th>
                <th class="{sorter: false} count column">In stock</th>
            </tr>
        </thead>
        <?php
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'orderby' =>'title',
                'order' => 'asc',
                'product_cat' => 'steer',
                'meta_query' => array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                    )
                )
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); 
            global $product;
            $brand = array_shift( wc_get_product_terms( $product->id, 'pa_brand', array( 'fields' => 'names' ) ) );
            $model = array_shift( wc_get_product_terms( $product->id, 'pa_model', array( 'fields' => 'names' ) ) );
            // $type = array_shift( wc_get_product_terms( $product->id, 'pa_tire-type', array( 'fields' => 'names' ) ) );
            $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
            // $rtype = null;
            $rsize = null;
            if (strpos($size, 'R22.5') !== false) {
                if ($size === '11R22.5') {
                    $rsize = 'B';
                } else {
                    $rsize = 'A';
                }
            } else if (strpos($size, 'R24.5') !== false) {
                $rsize = 'C';
            } else {
                $rsize = 'D';
            }

            // if (strpos($type, 'Steer') !== false) {
            //     $rtype = 'A';
            // } else if (strpos($type, 'Drive') !== false) {
            //     $rtype = 'B';
            // } else if (strpos($type, 'Trailer') !== false) {
            //     $rtype = 'C';
            // } else if (strpos($type, 'All') !== false) {
            //     $rtype = 'D';
            // } else {
            //     $rtype = 'E';
            // }
        ?>
            <tr>
                <td class="title column"><?php the_title(); ?></td>
                <td class="brand column"><?php echo $brand; ?></td>
                <td class="model column"><?php echo $model; ?></td>
                <!-- <td class="type column" data-type="<?php echo $rtype ?>"><?php echo $type; ?></td> -->
                <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
                <td class="count column"><?php echo $product->get_stock_quantity(); ?></td>
                <!-- <td class="price column"><?php echo $product->get_price_html(); ?></td> -->
            </tr>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
    </table>
    <div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
            <div class="vc_column-inner ">
                <div class="wpb_wrapper">
                    <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
                        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.drive&quot;).trigger(&quot;sorton&quot;, [ [[0,0]] ]);">Sort by Name</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-4">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.drive&quot;).trigger(&quot;sorton&quot;, [ [[3,0]] ]);">Sort by Size</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <table id="inventory" class="inventory drive">
        <thead>
            <tr>
                <th class="title column">Drive Tires</th>
                <th class="{sorter: false} brand column">Brand</th>
                <th class="{sorter: false} model column">Model</th>
                <th class="size column">Size</th>
                <th class="{sorter: false} count column">In stock</th>
            </tr>
        </thead>
        <?php
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'orderby' =>'title',
                'order' => 'asc',
                'product_cat' => 'drive',
                'meta_query' => array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                    )
                )
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); 
            global $product;
            $brand = array_shift( wc_get_product_terms( $product->id, 'pa_brand', array( 'fields' => 'names' ) ) );
            $model = array_shift( wc_get_product_terms( $product->id, 'pa_model', array( 'fields' => 'names' ) ) );
            // $type = array_shift( wc_get_product_terms( $product->id, 'pa_tire-type', array( 'fields' => 'names' ) ) );
            $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
            // $rtype = null;
            $rsize = null;
            if (strpos($size, 'R22.5') !== false) {
                if ($size === '11R22.5') {
                    $rsize = 'B';
                } else {
                    $rsize = 'A';
                }
            } else if (strpos($size, 'R24.5') !== false) {
                $rsize = 'C';
            } else {
                $rsize = 'D';
            }

            // if (strpos($type, 'Steer') !== false) {
            //     $rtype = 'A';
            // } else if (strpos($type, 'Drive') !== false) {
            //     $rtype = 'B';
            // } else if (strpos($type, 'Trailer') !== false) {
            //     $rtype = 'C';
            // } else if (strpos($type, 'All') !== false) {
            //     $rtype = 'D';
            // } else {
            //     $rtype = 'E';
            // }
        ?>
            <tr>
                <td class="title column"><?php the_title(); ?></td>
                <td class="brand column"><?php echo $brand; ?></td>
                <td class="model column"><?php echo $model; ?></td>
                <!-- <td class="type column" data-type="<?php echo $rtype ?>"><?php echo $type; ?></td> -->
                <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
                <td class="count column"><?php echo $product->get_stock_quantity(); ?></td>
                <!-- <td class="price column"><?php echo $product->get_price_html(); ?></td> -->
            </tr>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
    </table>
    <div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
            <div class="vc_column-inner ">
                <div class="wpb_wrapper">
                    <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
                        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.trailer&quot;).trigger(&quot;sorton&quot;, [ [[0,0]] ]);">Sort by Name</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-4">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.trailer&quot;).trigger(&quot;sorton&quot;, [ [[3,0]] ]);">Sort by Size</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <table id="inventory" class="inventory trailer">
        <thead>
            <tr>
                <th class="title column">Trailer Tires</th>
                <th class="{sorter: false} brand column">Brand</th>
                <th class="{sorter: false} model column">Model</th>
                <th class="size column">Size</th>
                <th class="{sorter: false} count column">In stock</th>
            </tr>
        </thead>
        <?php
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'orderby' =>'title',
                'order' => 'asc',
                'product_cat' => 'trailer, all-position',
                'meta_query' => array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                    )
                )
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); 
            global $product;
            $brand = array_shift( wc_get_product_terms( $product->id, 'pa_brand', array( 'fields' => 'names' ) ) );
            $model = array_shift( wc_get_product_terms( $product->id, 'pa_model', array( 'fields' => 'names' ) ) );
            // $type = array_shift( wc_get_product_terms( $product->id, 'pa_tire-type', array( 'fields' => 'names' ) ) );
            $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
            // $rtype = null;
            $rsize = null;
            if (strpos($size, 'R22.5') !== false) {
                if ($size === '11R22.5') {
                    $rsize = 'B';
                } else {
                    $rsize = 'A';
                }
            } else if (strpos($size, 'R24.5') !== false) {
                $rsize = 'C';
            } else {
                $rsize = 'D';
            }

            // if (strpos($type, 'Steer') !== false) {
            //     $rtype = 'A';
            // } else if (strpos($type, 'Drive') !== false) {
            //     $rtype = 'B';
            // } else if (strpos($type, 'Trailer') !== false) {
            //     $rtype = 'C';
            // } else if (strpos($type, 'All') !== false) {
            //     $rtype = 'D';
            // } else {
            //     $rtype = 'E';
            // }
        ?>
            <tr>
                <td class="title column"><?php the_title(); ?></td>
                <td class="brand column"><?php echo $brand; ?></td>
                <td class="model column"><?php echo $model; ?></td>
                <!-- <td class="type column" data-type="<?php echo $rtype ?>"><?php echo $type; ?></td> -->
                <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
                <td class="count column"><?php echo $product->get_stock_quantity(); ?></td>
                <!-- <td class="price column"><?php echo $product->get_price_html(); ?></td> -->
            </tr>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
    </table>
    <div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
            <div class="vc_column-inner ">
                <div class="wpb_wrapper">
                    <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
                        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.parts&quot;).trigger(&quot;sorton&quot;, [ [[0,0]] ]);">Sort by Name</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-4">
                            <div class="vc_column-inner ">
                                <div class="wpb_wrapper">
                                    <div class="vc_btn3-container sort-size sort vc_btn3-center">
                                        <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.inventory.parts&quot;).trigger(&quot;sorton&quot;, [ [[3,0]] ]);">Sort by Size</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <table id="inventory" class="inventory parts">
        <thead>
            <tr>
                <th class="title column">Parts</th>
                <th class="{sorter: false} brand column">Brand</th>
                <th class="{sorter: false} model column">Model</th>
                <th class="size column">Size</th>
                <th class="{sorter: false} count column">In stock</th>
            </tr>
        </thead>
        <?php
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'orderby' =>'title',
                'order' => 'asc',
                'product_tag' => 'parts',
                'meta_query' => array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                    )
                )
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); 
            global $product;
            $brand = array_shift( wc_get_product_terms( $product->id, 'pa_brand', array( 'fields' => 'names' ) ) );
            $model = array_shift( wc_get_product_terms( $product->id, 'pa_model', array( 'fields' => 'names' ) ) );
            // $type = array_shift( wc_get_product_terms( $product->id, 'pa_tire-type', array( 'fields' => 'names' ) ) );
            $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
            // $rtype = null;
            $rsize = null;
            if (strpos($size, 'R22.5') !== false) {
                if ($size === '11R22.5') {
                    $rsize = 'B';
                } else {
                    $rsize = 'A';
                }
            } else if (strpos($size, 'R24.5') !== false) {
                $rsize = 'C';
            } else {
                $rsize = 'D';
            }

            // if (strpos($type, 'Steer') !== false) {
            //     $rtype = 'A';
            // } else if (strpos($type, 'Drive') !== false) {
            //     $rtype = 'B';
            // } else if (strpos($type, 'Trailer') !== false) {
            //     $rtype = 'C';
            // } else if (strpos($type, 'All') !== false) {
            //     $rtype = 'D';
            // } else {
            //     $rtype = 'E';
            // }
        ?>
            <tr>
                <td class="title column"><?php the_title(); ?></td>
                <td class="brand column"><?php echo $brand; ?></td>
                <td class="model column"><?php echo $model; ?></td>
                <!-- <td class="type column" data-type="<?php echo $rtype ?>"><?php echo $type; ?></td> -->
                <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
                <td class="count column"><?php echo $product->get_stock_quantity(); ?></td>
                <!-- <td class="price column"><?php echo $product->get_price_html(); ?></td> -->
            </tr>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
    </table>
    <div class="entry-links"><?php wp_link_pages(); ?></div>
<?php else : ?>
    <div class="notification" style="background-color: #007be3; color: #fff; border-radius: 3px; padding: 1.25rem 2.5rem 1.25rem 1.5rem; position: relative; text-align: center;">This page is for registered users only. Please <a href="/wp-login.php?redirect_to=/current-inventory/" style="color: #fff;"><strong>login</strong></a> or <a href="/wp-login.php?action=register" style="color: #fff;"><strong>register</strong></a> to view our inventory.</div>
<?php endif; ?>
</section>
</article>
<?php if ( ! post_password_required() ) comments_template( '', true ); ?>
<?php endwhile; endif; ?>
</section>
<?php get_sidebar(); ?>
<?php get_footer(); ?>