<?php get_header(); ?>
<section id="content" role="main">
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<header class="header">
<h1 class="entry-title"><?php the_title(); ?></h1> <?php edit_post_link(); ?>
</header>
<section class="entry-content">
<?php if ( has_post_thumbnail() ) { the_post_thumbnail(); } ?>
<?php the_content(); ?>
<div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
<div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
  <div class="vc_column-inner ">
    <div class="wpb_wrapper">
      <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.steer&quot;).trigger(&quot;sorton&quot;, [ [[2,0]] ]);">Sort by Size</button>
              </div>
            </div>
          </div>
        </div>
        <div class="wpb_column vc_column_container vc_col-sm-4">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.steer&quot;).trigger(&quot;sorton&quot;, [ [[4,0]] ]);">Sort by Price</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<table id="price-table" class="price-table steer">
    <thead>
        <tr>
            <th class="{sorter: false} brand column">Steer Tires</th>
            <th class="{sorter: false} model column">Model</th>
            <th class="size column">Size</th>
            <th class="{sorter: false} type column">Tread</th>
            <th class="price column">PRICE/ EA. TIRE</th>
            <th class="{sorter: false} price-multi column">2 Tires installed</th>
        </tr>
    </thead>
    <?php
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => 1000,
            'orderby' =>'title',
            'order' => 'asc',
            'product_cat' => 'steer',
            'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'instock'
                )
            )
        );
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post(); 
        global $product;
        $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
        $rsize = null;
        if (strpos($size, 'R22.5') !== false) {
            if ($size === '11R22.5') {
                $rsize = 'B';
            } else {
                $rsize = 'A';
            }
        } else if (strpos($size, 'R24.5') !== false) {
            $rsize = 'C';
        } else {
            $rsize = 'D';
        }
    ?>
        <tr>
            <td class="brand column"><?php $brandvalues = get_the_terms( $product->id, 'pa_brand'); foreach ( $brandvalues as $brandvalue ) {echo '<a href="'.get_permalink($product_id).'">'.$brandvalue->name.'</a>';}?></td>
            <td class="model column"><?php $modelvalues = get_the_terms( $product->id, 'pa_model'); foreach ( $modelvalues as $modelvalue ) {echo $modelvalue->name;}?></td>
            <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
            <td class="tread column"><?php $treadvalues = get_the_terms( $product->id, 'pa_tread'); foreach ( $treadvalues as $treadvalue ) {echo $treadvalue->name;}?></td>
            <td class="price column"><?php echo $product->get_price_html(); ?></td>
            <td class="price-multi column">$<?php $payinfront = (int)$product->get_price(); $totalprice = $payinfront * 2; echo number_format($totalprice, 2, '.', '.'); ?></td>
        </tr>
    <?php endwhile; ?>
    <?php wp_reset_query(); ?>
</table>
<div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
<div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
  <div class="vc_column-inner ">
    <div class="wpb_wrapper">
      <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.drive&quot;).trigger(&quot;sorton&quot;, [ [[2,0]] ]);">Sort by Size</button>
              </div>
            </div>
          </div>
        </div>
        <div class="wpb_column vc_column_container vc_col-sm-4">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.drive&quot;).trigger(&quot;sorton&quot;, [ [[4,0]] ]);">Sort by Price</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<table id="price-table" class="price-table drive">
    <thead>
        <tr>
            <th class="{sorter: false} brand column">Drive Tires</th>
            <th class="{sorter: false} model column">Model</th>
            <th class="size column">Size</th>
            <th class="{sorter: false} type column">Tread</th>
            <th class="price column">PRICE/ EA. TIRE</th>
            <th class="{sorter: false} price-multi column">8 Tires installed</th>
        </tr>
    </thead>
    <?php
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => 1000,
            'orderby' =>'title',
            'order' => 'asc',
            'product_cat' => 'drive',
            'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'instock'
                )
            )
        );
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post(); 
        global $product;
        $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
        $rsize = null;
        if (strpos($size, 'R22.5') !== false) {
            if ($size === '11R22.5') {
                $rsize = 'B';
            } else {
                $rsize = 'A';
            }
        } else if (strpos($size, 'R24.5') !== false) {
            $rsize = 'C';
        } else {
            $rsize = 'D';
        }
    ?>
        <tr>
        <td class="brand column"><?php $brandvalues = get_the_terms( $product->id, 'pa_brand'); foreach ( $brandvalues as $brandvalue ) {echo '<a href="'.get_permalink($product_id).'">'.$brandvalue->name.'</a>';}?></td>
            <td class="model column"><?php $modelvalues = get_the_terms( $product->id, 'pa_model'); foreach ( $modelvalues as $modelvalue ) {echo $modelvalue->name;}?></td>
            <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
            <td class="tread column"><?php $treadvalues = get_the_terms( $product->id, 'pa_tread'); foreach ( $treadvalues as $treadvalue ) {echo $treadvalue->name;}?></td>
            <td class="price column"><?php echo $product->get_price_html(); ?></td>
            <td class="price-multi column">$<?php $payinfront = (int)$product->get_price(); $totalprice = $payinfront * 8; echo number_format($totalprice, 2, '.', '.'); ?></td>
        </tr>
    <?php endwhile; ?>
    <?php wp_reset_query(); ?>
</table>
<div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
<div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
  <div class="vc_column-inner ">
    <div class="wpb_wrapper">
      <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
        <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.trailer&quot;).trigger(&quot;sorton&quot;, [ [[2,0]] ]);">Sort by Size</button>
              </div>
            </div>
          </div>
        </div>
        <div class="wpb_column vc_column_container vc_col-sm-4">
          <div class="vc_column-inner ">
            <div class="wpb_wrapper">
              <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.trailer&quot;).trigger(&quot;sorton&quot;, [ [[4,0]] ]);">Sort by Price</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<table id="price-table" class="price-table trailer">
    <thead>
        <tr>
            <th class="{sorter: false} brand column">Trailer Tires</th>
            <th class="{sorter: false} model column">Model</th>
            <th class="size column">Size</th>
            <th class="{sorter: false} type column">Tread</th>
            <th class="price column">PRICE/ EA. TIRE</th>
            <th class="{sorter: false} price-multi column">8 Tires installed</th>
        </tr>
    </thead>
    <?php
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => 1000,
            'orderby' =>'title',
            'order' => 'asc',
            'product_cat' => 'trailer, all-position',
            'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'instock'
                )
            )
        );
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post(); 
        global $product;
        $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
        $rsize = null;
        if (strpos($size, 'R22.5') !== false) {
            if ($size === '11R22.5') {
                $rsize = 'B';
            } else {
                $rsize = 'A';
            }
        } else if (strpos($size, 'R24.5') !== false) {
            $rsize = 'C';
        } else {
            $rsize = 'D';
        }
    ?>
        <tr>
            <td class="brand column"><?php $brandvalues = get_the_terms( $product->id, 'pa_brand'); foreach ( $brandvalues as $brandvalue ) {echo '<a href="'.get_permalink($product_id).'">'.$brandvalue->name.'</a>';}?></td>
            <td class="model column"><?php $modelvalues = get_the_terms( $product->id, 'pa_model'); foreach ( $modelvalues as $modelvalue ) {echo $modelvalue->name;}?></td>
            <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
            <td class="tread column"><?php $treadvalues = get_the_terms( $product->id, 'pa_tread'); foreach ( $treadvalues as $treadvalue ) {echo $treadvalue->name;}?></td>
            <td class="price column"><?php echo $product->get_price_html(); ?></td>
            <td class="price-multi column">$<?php $payinfront = (int)$product->get_price(); $totalprice = $payinfront * 8; echo number_format($totalprice, 2, '.', '.'); ?></td>
        </tr>
    <?php endwhile; ?>
    <?php wp_reset_query(); ?>
</table>
<div class="vc_row wpb_row vc_row-fluid vc_column-gap-30">
  <div class="wpb_column vc_column_container vc_col-sm-8 vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-sm-offset-2">
    <div class="vc_column-inner ">
      <div class="wpb_wrapper">
        <div class="vc_row wpb_row vc_inner vc_row-fluid vc_column-gap-30">
          <div class="wpb_column vc_column_container vc_col-sm-4 vc_col-sm-offset-2">
            <div class="vc_column-inner ">
              <div class="wpb_wrapper">
                <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                  <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.parts&quot;).trigger(&quot;sorton&quot;, [ [[2,0]] ]);">Sort by Size</button>
                </div>
              </div>
            </div>
          </div>
          <div class="wpb_column vc_column_container vc_col-sm-4">
            <div class="vc_column-inner ">
              <div class="wpb_wrapper">
                <div class="vc_btn3-container  sort-size sort vc_btn3-center">
                  <button class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-square vc_btn3-style-flat vc_btn3-color-grey" onclick="jQuery(&quot;.price-table.parts&quot;).trigger(&quot;sorton&quot;, [ [[4,0]] ]);">Sort by Price</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<table id="price-table" class="price-table parts">
    <thead>
        <tr>
            <th class="{sorter: false} brand column">Parts</th>
            <th class="{sorter: false} model column">Model</th>
            <th class="size column">Size</th>
            <th class="{sorter: false} type column">Tread</th>
            <th class="price column">PRICE/ EA. PART</th>
        </tr>
    </thead>
    <?php
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => 1000,
            'orderby' =>'title',
            'order' => 'asc',
            'product_tag' => 'parts',
            'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'instock'
                )
            )
        );
        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) : $loop->the_post(); 
        global $product;
        $size = array_shift( wc_get_product_terms( $product->id, 'pa_size', array( 'fields' => 'names' ) ) );
        $rsize = null;
        if (strpos($size, 'R22.5') !== false) {
            if ($size === '11R22.5') {
                $rsize = 'B';
            } else {
                $rsize = 'A';
            }
        } else if (strpos($size, 'R24.5') !== false) {
            $rsize = 'C';
        } else {
            $rsize = 'D';
        }
    ?>
        <tr>
            <td class="title column"><a href="<?php echo get_permalink($product_id); ?>"><?php the_title(); ?></a></td>
            <td class="model column"><?php $modelvalues = get_the_terms( $product->id, 'pa_model'); foreach ( $modelvalues as $modelvalue ) {echo $modelvalue->name;}?></td>
            <td class="size column" data-size="<?php echo $rsize ?>"><?php echo $size; ?></td>
            <td class="tread column"><?php $treadvalues = get_the_terms( $product->id, 'pa_tread'); foreach ( $treadvalues as $treadvalue ) {echo $treadvalue->name;}?></td>
            <td class="price column"><?php echo $product->get_price_html(); ?></td>
        </tr>
    <?php endwhile; ?>
    <?php wp_reset_query(); ?>
</table>
<div class="entry-links"><?php wp_link_pages(); ?></div>
</section>
</article>
<?php if ( ! post_password_required() ) comments_template( '', true ); ?>
<?php endwhile; endif; ?>
</section>
<?php get_sidebar(); ?>
<?php get_footer(); ?>