<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function($){
  var $= jQuery.noConflict();

  // inventory was here
  $.tablesorter.addParser({
    // set a unique id
    id: 'tiredata',
    is: function(s) {
      // return false so this parser is not auto detected
      return false;
    },
    format: function(s, table, cell, cellIndex) {
      var $cell = $(cell);
      if (cellIndex === 3) {
        return $cell.attr('data-size') || s;
      }
      return s;
    },
    // flag for filter widget (true = ALWAYS search parsed values; false = search cell text)
    parsed: false,
    // set type, either numeric or text
    type: 'text'
  });
  $.tablesorter.addParser({
    // set a unique id
    id: 'tiredata-price',
    is: function(s) {
      // return false so this parser is not auto detected
      return false;
    },
    format: function(s, table, cell, cellIndex) {
      var $cell = $(cell);
      if (cellIndex === 2) {
        return $cell.attr('data-size') || s;
      }
      return s;
    },
    // flag for filter widget (true = ALWAYS search parsed values; false = search cell text)
    parsed: false,
    // set type, either numeric or text
    type: 'text'
  });
  
  $('.inventory').tablesorter({
    sortList: [[3,0]],
    headers: { 
      3: { sorter: 'tiredata' },
      4: { sorter: 'tiredata' }
    }
  });

  $('.price-table').tablesorter({
    sortList: [[2,0], [4,0]],
    headers: { 
      2: { sorter: 'tiredata-price' }
    }
  });

  $('.products > li').each(function(){

    var productDetailsSrc = $(this).find('a:first').attr('href');

    $(this).append('<div id="view-more-btn"><a href="">VIEW MORE</a></div>');
    $(this).find('#view-more-btn a').attr('href', productDetailsSrc);
    $(this).find('.add_to_cart_button').remove();

    var productTitle = $('.woocommerce-loop-product__title', this);
    var viewMoreButton = $('#view-more-btn', this);
    var productPrice = $('.price', this);
    var productAttributes = $('.custom-attributes', this);
    var productImageLink = $('.products > li.product > a', this);

    $(productTitle).insertBefore(viewMoreButton);
    $(productPrice).insertBefore(viewMoreButton);
    $(productAttributes).appendTo(productImageLink);

  });

  $('.single-deals .single-deal-expiry-date').prependTo(".single-deals .entry-content");
  $('.single-deals .single-deal-discount').prependTo(".single-deals .entry-content");
  $('.single-deals .footer').appendTo(".single-deals .entry-content");
  
  setTimeout(function(){
    $('#n2-ss-2-arrow-previous, #n2-ss-2-arrow-next').wrapAll('<div class="slide-navigation" />');
    
  }, 100);
  
  $(".owl-prev img").attr("src","/wp-content/uploads/2017/08/prev.png");
  $(".owl-next img").attr("src","/wp-content/uploads/2017/08/next.png");
  
  $('.single-product #content').prepend('<header class="woocommerce-products-header"><h1 class="woocommerce-products-header__title page-title">Tires</h1></header>')
  $('.woocommerce-products-header').insertAfter('.woocommerce-breadcrumb');
  $('.woocommerce-tabs').appendTo('.woocommerce div.product div.summary');
  $('.comment-form-comment').insertAfter('.comment-form-email');
  
  $('.pa_dimensions > .attribute-label > .attribute-label-text').text('Size');
  $('.product .summary.entry-summary > .custom-attributes').insertBefore('.product .summary.entry-summary .price');
  $('.product .summary.entry-summary > .product_meta').insertBefore('.product .summary.entry-summary .price');
  
  $(".woocommerce div.product div.summary .stock.in-stock").html(function(index, old) {
    return old.replace(/(\b\w+)$/, '<span class="stock-quantity">$1</span>');
  });
  
  $('#woocommerce_layered_nav-2 select option:first').text('Sort by type');
  $('#woocommerce_layered_nav-3 select option:first').text('Sort by size');
  
  $('.sku_wrapper')
    .contents()
    .filter(function() {
    return this.nodeType == 3; //Node.TEXT_NODE
  }).remove();
  
  var type = $('.entry-summary .custom-attributes .pa_tire-type > .attribute-value').text();
  var title = $('.entry-title').text();
  var size = $('.entry-summary .custom-attributes .pa_size > .attribute-value').text();
  var tread = $('.entry-summary .custom-attributes .pa_tread > .attribute-value').text();
  var itemNumber = $('.sku').text();
  
  $('.woocommerce div.product div.summary').append('<div id="request"><div class="phone">Call now<span>1-630-350-8622</span></div><img class="divider" src="/wp-content/uploads/2017/08/divider.png" alt="Request divider"><a id="inline" class="btn-read-more popup-trigger" data-type="'+type+'" data-title="'+title+'" data-size="'+size+'" data-tread="'+tread+'" data-itemnumber="'+itemNumber+'" href="#data">Send a request</a></div>');
  
  $("#field_555gt").prop("readonly", true);
  $("#field_nphy0").prop("readonly", true);
  $("#field_rd55t").prop("readonly", true);
  $("#field_t1dhs").prop("readonly", true);
  $("#field_rvoew").prop("readonly", true);

  $('.popup-trigger').on('click', function(){

    $('#field_555gt').val($(this).data('type'));
    $('#field_nphy0').val($(this).data('title'));
    $('#field_rd55t').val($(this).data('size'));
    $('#field_t1dhs').val($(this).data('tread'));
    $('#field_rvoew').val($(this).data('itemnumber'));

  });

  $("a#inline").fancybox({
    'titlePosition': 'inside',
    'autoScale': true,
    'width': 410,
    'height': 'auto',
    'autoDimensions': false,
    'transitionIn': 'none',
    'transitionOut': 'none',
    // fix inline bug
    'onCleanup': function () {
      var inlineId = $('#fancybox-content div div').attr('id');
      $('.fancybox-inline-tmp').replaceWith($("#"+inlineId));
    }
  });
  
  //Search
  $('#custom_html-3 > .textwidget').append('<div class="search-btn"><i class="fa fa-search fa-2x" aria-hidden="true"></i></div>');
  $('#search-3').appendTo('#custom_html-3 > .textwidget');
  $('.search-btn').on('click', function() {
    $('.widget_search').toggleClass('visible');
  });
  
  // Search filters
  $('select.dropdown_layered_nav_tire-type option[value="112"]').remove();
  $('select.dropdown_layered_nav_tire-type option[value="rims"]').remove();
  $('select.dropdown_layered_nav_size option[value="109"]').remove();
  
  $('#menu').before('<div class="nav-trigger"><span></span></div>');
  $('.nav-trigger').on('click', function(e) {
    $(this).toggleClass('active');
    $(this).next().toggleClass('open');
    $(this).next().stop().slideToggle(150);
    e.preventDefault();
  });
  $('#searchform').appendTo('#custom_html-3 .textwidget');
  if (jQuery(window).width() <= 768) {
    jQuery('#menu .menu-item-has-children').click(function(e){
      var $this = jQuery(this);
      var sub = $this.find('> .sub-menu');
      if(jQuery(sub).is(":hidden")) {
        e.preventDefault();
        jQuery(sub).slideDown();
      }
    });
    jQuery(window).on('scroll', function () {
      if (jQuery(window).scrollTop() > 40) {
        jQuery('#header').addClass('fixed');
      } else {
        jQuery('#header').removeClass('fixed');
      }
    });     
  } else {
    $('.dropdown_layered_nav_tire-type').niceSelect();
    $('.dropdown_layered_nav_size').niceSelect(); 
  }
});
document.addEventListener("touchstart", function(){}, true);</script>
<!-- end Simple Custom CSS and JS -->
