<?php

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

function connect_page() {

  $configs = require_once plugin_dir_path( __FILE__ ) . 'config.php';

  $redirect_uri = $configs['oauth_redirect_uri'];
  $openID_redirect_uri = $configs['openID_redirect_uri'];
  $refreshTokenPage = $configs['refreshTokenPage'];
  $clearSessionPage = $configs['clearSession'];

  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $accessToken = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'access_token' ");

  echo '<div class="wh-wrap">';
  if ($accessToken) {
    echo "<h1 class='wp-heading-inline'>You are connected to our QuickBooks app</h1>";
    echo "<p>You can disconnect from <a href='".$clearSessionPage."'>here</a>.</p>";
  } else {
    echo "<h1 class='wp-heading-inline'>Please Complete the \"Connect to QuickBooks\" OAuth 2 flow:</h1>";
    echo '<p>Click on the button below to connect to our QuickBooks app.</p>';
    echo "<br /> <ipp:connectToIntuit></ipp:connectToIntuit><br />";
  }

?>
  <script type="text/javascript" src="https://appcenter.intuit.com/Content/IA/intuit.ipp.anywhere-1.3.3.js"></script>
  <script type="text/javascript">
    var redirectUrl = '<?=$redirect_uri?>'
    intuit.ipp.anywhere.setup({
      grantUrl: redirectUrl,
      datasources: {
        quickbooks : true,
        payments : false
      }
    });
  </script>
<?php
    echo '</div>';
  }
