<?php
  if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
  }
  use QuickBooksOnline\API\DataService\DataService;
  use QuickBooksOnline\API\Core\ServiceContext;
  use QuickBooksOnline\API\PlatformService\PlatformService;
  use QuickBooksOnline\API\Utility\Configuration\ConfigurationManager;

  function test_page() {
    session_start();

    $configs = require_once plugin_dir_path( __FILE__ ) . 'oauth2/config.php';
    $clientId = $configs['client_id'];
    $clientSecret = $configs['client_secret'];
    $baseUrl = $configs['base_url'];

    $dataService = DataService::Configure(array(
      'auth_mode' => 'oauth2',
      'ClientID' => $clientId,
      'ClientSecret' => $clientSecret,
      'accessTokenKey' =>  $_SESSION['access_token'],
      'refreshTokenKey' => $_SESSION['refresh_token'],
      'QBORealmID' => $_SESSION['realm_id'],
      'baseUrl' => $baseUrl
    ));

    $entities = $dataService->Query("SELECT * FROM Item");
    echo "Total number of items: ";
    echo count($entities);
    echo "\n";

    $filesCount = 0;
    $postUpdateCount = 0;
    $postNewCount = 0;
    $postNoSkuCount = 0;

    foreach ($entities as $entitie) {
      $filesCount += 1;

      // var_dump($entitie);
      $qb_name = $entitie->Name;
      $qb_sku = $entitie->Sku;
      $qb_price = $entitie->UnitPrice;
      $qb_quantity = $entitie->QtyOnHand;
      if ((int)$qb_quantity > 0) {
        $qb_stock = 'instock';
      } else {
        $qb_stock = 'outofstock';
      }

      $updateProductArr = array(
        "post_type" => "product",
        // "post_status" => "publish",
        "meta_input" => array(
          "_price" => $qb_price,
          "_regular_price" => $qb_price,
          "_ls_sell_price" => $qb_price,
          "_stock" => $qb_quantity,
          "_stock_status" => $qb_stock,
          "_manage_stock" => "yes"
        )
      );

      $addProductArr = array(
        "post_author" => 1,
        "post_title" => $qb_name,
        "post_status"   => "draft",
        "post_type"     => "product",
        "meta_input"    => array(
          "_sku" => $qb_sku,
          "_price" => $qb_price,
          "_regular_price" => $qb_price,
          "_ls_sell_price" => $qb_price,
          "_stock" => $qb_quantity,
          "_stock_status" => $qb_stock,
          "_manage_stock" => "yes"
        )
      );

      $args = array(
        "post_type"      => "product",
        "post_status"    => "any",
        "posts_per_page" => -1,
        "meta_query"     => array(
          array(
            "key"     => "_sku",
            "value"	  => $qb_sku,
              "compare" => "="
          )
        )
      );

      $my_query = new WP_Query( $args );
      if ( $my_query->have_posts() ) {
        while ( $my_query->have_posts() ) {
          $my_query->the_post();
          $the_post_id = get_the_id();
          $meta = get_post_meta($the_post_id);
          $sku = $meta['_sku'][0];
          // var_dump($meta);
          if ($qb_sku == $sku) {
            $updateProductArr["ID"] = $the_post_id;
            $upID = wp_update_post($updateProductArr);
            $postUpdateCount += 1;
          }
        }
      } else {
        // var_dump($qb_sku);
        if ($qb_sku != NULL) {
          $pId = wp_insert_post($addProductArr);
          $postNewCount += 1;
        } else {
          $postNoSkuCount += 1;
        }
      }
      wp_reset_postdata();
    }
    echo "<p>" . $filesCount . " looped files</p>";
    echo "<p>" . $postUpdateCount . " were updated</p>";
    echo "<p>" . $postNewCount . " new posts added</p>";
    echo "<p>" . $postNoSkuCount . " posts not added because they are without sku</p>";

    $CompanyInfo = $dataService->getCompanyInfo();
    $error = $dataService->getLastError();
    if ($error != null) {
        echo "The Status code is: " . $error->getHttpStatusCode() . "\n";
        echo "The Helper message is: " . $error->getOAuthHelperError() . "\n";
        echo "The Response message is: " . $error->getResponseBody() . "\n";
        echo "The Intuit Helper message is: IntuitErrorType:{" . $error->getIntuitErrorType() . "} IntuitErrorCode:{" . $error->getIntuitErrorCode() . "} IntuitErrorMessage:{" . $error->getIntuitErrorMessage() . "} IntuitErrorDetail:{" . $error->getIntuitErrorDetail() . "}";
    }
    // var_dump($CompanyInfo);
  }
?>