<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

function welcome_page() {

  $configs = require_once plugin_dir_path( __FILE__ ) . 'oauth2/config.php';
  $mainPage = $configs['mainPage'];
  
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $accessToken = $wpdb->get_var( "SELECT value FROM ".$table_name." WHERE name = 'access_token' ");
  $table_stats = $wpdb->prefix . 'wh_quickbooks_stats';
  $allProducts = $wpdb->get_var( "SELECT value FROM $table_stats WHERE name = 'qb_products' ");
  $apTime = $wpdb->get_var( "SELECT time FROM $table_stats WHERE name = 'qb_products' ");
  $updatedProducts = $wpdb->get_var( "SELECT value FROM $table_stats WHERE name = 'updated_products' ");
  $upTime = $wpdb->get_var( "SELECT time FROM $table_stats WHERE name = 'updated_products' ");
  $newProducts = $wpdb->get_var( "SELECT value FROM $table_stats WHERE name = 'new_products' ");
  $npTime = $wpdb->get_var( "SELECT time FROM $table_stats WHERE name = 'new_products' ");
  $noSkuProducts = $wpdb->get_var( "SELECT value FROM $table_stats WHERE name = 'no_sku_products' ");
  $nspTime = $wpdb->get_var( "SELECT time FROM $table_stats WHERE name = 'no_sku_products' ");

  echo '<div class="wrap">';
  echo "<h1 class='wp-heading-inline'>Welcome to WebHips's QuickBooks Sync plugin.</h1>";
  if ($accessToken) {
    echo "<p>Great, you are <span style='color:#36af0e;'>connected</span> to QuickBooks</p>";
    echo '
    <table class="wp-list-table widefat fixed striped comments">
      <thead>
        <tr>
          <th scope="col" id="stats" class="manage-column column-stats">Stats</th>
          <th scope="col" id="value" class="manage-column column-value">Value</th>
          <th scope="col" id="date" class="manage-column column-date">Last Update</th>
        </tr>
      </thead>
      <tbody id="the-list">
        <tr>
          <td>
            <strong>QuickBooks products found</strong>
          </td>
          <td>
            <strong>'.$allProducts.'</strong>
          </td>
          <td class="date column-date">
            <strong>'.sec2hms($apTime).' ago</strong>
          </td>
        </tr>
        <tr>
          <td>
            <strong>Updated products</strong>
          </td>
          <td>
            <strong>'.$updatedProducts.'</strong>
          </td>
          <td class="date column-date">
            <strong>'.sec2hms($upTime).' ago</strong>
          </td>
        </tr>
        <tr>
          <td>
            <strong>Added new products as draft</strong>
          </td>
          <td>
            <strong>'.$newProducts.'</strong>
          </td>
          <td class="date column-date">
            <strong>'.sec2hms($npTime).' ago</strong>
          </td>
        </tr>
        <tr>
          <td>
            <strong>NOT added products (without SKU)</strong>
          </td>
          <td>
            <strong>'.$noSkuProducts.'</strong>
          </td>
          <td class="date column-date">
            <strong>'.sec2hms($nspTime).' ago</strong>
          </td>
        </tr>
      </tbody>
      <tfoot>
        <tr>
          <th scope="col" id="stats" class="manage-column column-stats">Stats</th>
          <th scope="col" id="value" class="manage-column column-value">Value</th>
          <th scope="col" id="date" class="manage-column column-date">Last Update</th>
        </tr>
      </tfoot>
  
    </table>';
  } else {
    echo '<p>It looks like you are not connected to QuickBooks, please connect to our app on <a href="' . $mainPage . '">this</a> page';
  }
}