<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

global $wh_db_tokens_version;
global $wh_db_stats_version;
$wh_db_tokens_version = '1.0';
$wh_db_stats_version = '1.0';

function wh_db_tokens_install() {
  global $wpdb;
  global $wh_db_tokens_version;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    name varchar(191) DEFAULT '' NOT NULL,
    value longtext NOT NULL,
    PRIMARY KEY  (id)
  ) $charset_collate;";
  require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
  dbDelta( $sql );
  add_option( 'wh_db_tokens_version', $wh_db_tokens_version );
}
function wh_db_tokens_uninstall() {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_tokens';
  $wpdb->query("DROP TABLE IF EXISTS $table_name;");
  delete_option("wh_db_tokens_version");
}

function wh_db_stats_install() {
  global $wpdb;
  global $wh_db_stats_version;
  $table_name = $wpdb->prefix . 'wh_quickbooks_stats';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    name varchar(191) DEFAULT '' NOT NULL,
    value longtext NOT NULL,
    time varchar(191) DEFAULT '' NOT NULL,
    PRIMARY KEY  (id)
  ) $charset_collate;";
  require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
  dbDelta( $sql );
  add_option( 'wh_db_stats_version', $wh_db_stats_version );
}
function wh_db_stats_uninstall() {
  global $wpdb;
  $table_name = $wpdb->prefix . 'wh_quickbooks_stats';
  $wpdb->query("DROP TABLE IF EXISTS $table_name;");
  delete_option("wh_db_stats_version");
}
