<?php
/*
  Plugin Name: WebHips's Quickbooks Online Integration
  Description: This plugin syncs data from your online quickbooks account.
  Author: WebHips
  Author URI: http://webhips.com/
  Version: 0.2
*/
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

include( 'wh-db.php' );
register_deactivation_hook( __FILE__, 'wh_db_tokens_uninstall' );
register_deactivation_hook( __FILE__, 'wh_db_stats_uninstall' );
register_activation_hook( __FILE__, 'wh_db_tokens_install' );
register_activation_hook( __FILE__, 'wh_db_stats_install' );

include( 'wh-crons.php' );
register_activation_hook( __FILE__, 'wh_cron_up_activate' );
register_activation_hook( __FILE__, 'wh_cron_rt_activate' );
register_deactivation_hook( __FILE__, 'wh_cron_up_deactivate' );
register_deactivation_hook( __FILE__, 'wh_cron_rt_deactivate' );

require_once plugin_dir_path( __FILE__ ) . 'sdk/src/config.php';
require_once plugin_dir_path( __FILE__ ) . 'custom_cron_schedules.php';
require_once plugin_dir_path( __FILE__ ) . 'functions.php';
require_once plugin_dir_path( __FILE__ ) . 'pages.php';


add_action('wh_update_products', 'wh_products_to_update');
add_action('wh_refresh_token', 'wh_token_to_refresh');
require_once plugin_dir_path( __FILE__ ) . 'wh-up.php';
require_once plugin_dir_path( __FILE__ ) . 'wh-rt.php';
